/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class Categories
extends List
implements CommandListener {
    boolean showAlert = true;
    Alert confirm;
    Alert warning;
    Command confYes = new Command("Yes", 4, 1);
    Command confNo = new Command("No", 3, 2);
    Command rename;
    Command delete;
    Command back;
    Command add = new Command("Add", 4, 1);

    public Categories() {
        super("Categories", 3);
        this.back = new Command("Back", 2, 1);
        this.rename = new Command("Rename", 1, 1);
        this.delete = new Command("Delete", 1, 2);
        this.warning = new Alert("Warning", "Deleting or renaming categories will screw up your saved data.\nDo it only after a sucessful sync and without saved transactions.", Cash2ME.main.warning, AlertType.WARNING);
        this.warning.setTimeout(-2);
        this.warning.setCommandListener((CommandListener)this);
        this.confirm = new Alert("Delete", "Do you really want to delete the selected category?", Cash2ME.main.question, AlertType.CONFIRMATION);
        this.confirm.addCommand(this.confNo);
        this.confirm.addCommand(this.confYes);
        this.confirm.setCommandListener((CommandListener)this);
        this.addCommand(this.add);
        this.addCommand(this.back);
        this.addCommand(this.rename);
        this.addCommand(this.delete);
        this.setCommandListener(this);
    }

    public void load() {
        this.deleteAll();
        if (Cash2ME.main.rms.openRecStore("categories")) {
            String[] cat = Cash2ME.main.rms.readRecords();
            if (cat != null) {
                int i = 0;
                while (i < cat.length) {
                    this.append(cat[i], null);
                    ++i;
                }
            }
            Cash2ME.main.rms.closeRecStore();
        }
    }

    private void delete() {
        if (Cash2ME.main.rms.openRecStore("categories")) {
            Cash2ME.main.rms.deleteRecord(this.getString(this.getSelectedIndex()));
            Cash2ME.main.rms.closeRecStore();
        }
    }

    public void showAlert() {
        Cash2ME.display.setCurrent((Displayable)this.warning);
        this.showAlert = false;
    }

    public void setCurrent() {
        if (this.showAlert && Cash2ME.main.rms.listRecStores().length > 0) {
            this.showAlert();
        } else {
            this.load();
            Cash2ME.display.setCurrent((Displayable)this);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.back) {
            Cash2ME.main.transaction.reloadCategories();
            Cash2ME.main.transaction.setCurrent();
        } else if (c == this.delete) {
            if (this.getSelectedIndex() >= 0) {
                Cash2ME.display.setCurrent((Displayable)this.confirm);
            }
        } else if (c == this.confNo) {
            this.setCurrent();
        } else if (c == this.confYes && d == this.confirm) {
            this.delete();
            this.setCurrent();
        } else if (c == this.rename) {
            Cash2ME.main.categoryAdd.setCategory(this.getString(this.getSelectedIndex()));
            Cash2ME.main.categoryAdd.setCurrent();
        } else if (c == this.add) {
            Cash2ME.main.categoryAdd.setCurrent();
        } else if (d == this.warning) {
            this.setCurrent();
        }
    }
}

