/*
 * Decompiled with CFR 0.152.
 */
package com.hakore.krzak.Fremtris;

import com.hakore.krzak.Fremtris.Fremtris;
import com.hakore.krzak.Fremtris.FremtrisBlock;
import com.hakore.krzak.Fremtris.FremtrisBoard;
import com.hakore.krzak.Fremtris.FremtrisColor;
import com.hakore.krzak.Fremtris.FremtrisGameOverException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class FremtrisCanvas
extends Canvas
implements Runnable {
    private Image image;
    private Fremtris f;

    FremtrisCanvas(Fremtris fremtris) {
        this.f = fremtris;
        Display.getDisplay((MIDlet)fremtris).setCurrent((Displayable)this);
    }

    FremtrisCanvas(MIDlet mIDlet, Image image) {
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)this);
        this.setImage(image);
    }

    public void run() {
    }

    public int getHeight() {
        return super.getHeight();
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(FremtrisColor.getColorRGB(5));
            graphics.setFont(Font.getFont((int)32, (int)0, (int)8));
            graphics.drawString("Next", this.image.getWidth() + 5, 0, 4 | 0x10);
            int n = this.getHeight() / 20;
            if (n < 4) {
                n = 5;
            }
            graphics.drawImage(this.f.nextBlockInQueue.getImage(n), this.image.getWidth() + 5, graphics.getFont().getHeight(), 0x10 | 4);
            graphics.setColor(0);
            graphics.drawString(Fremtris.score + " points", this.image.getWidth() + 3, graphics.getFont().getHeight() * 3, 4 | 0x10);
            graphics.drawString(this.f.level + " Level", this.image.getWidth() + 3, graphics.getFont().getHeight() * 4, 4 | 0x10);
            graphics.setClip(0, 0, this.image.getWidth() + 1, this.image.getHeight() + 1);
            graphics.drawImage(this.image, 0, 0, 0x10 | 4);
            graphics.setColor(0);
            graphics.drawRect(0, 0, this.image.getWidth(), this.image.getHeight());
        }
    }

    public void paintBlockOnBoard(FremtrisBlock fremtrisBlock, FremtrisBoard fremtrisBoard) {
        FremtrisBoard fremtrisBoard2 = fremtrisBoard.clone1();
        fremtrisBoard2.putBlockOnBoard(fremtrisBlock, this.f);
        fremtrisBoard2.updateImage();
        this.setImage(fremtrisBoard2.getImage());
        fremtrisBoard2 = null;
    }

    public void keyPressed(int n) {
        FremtrisBlock fremtrisBlock = this.f.getBlock();
        FremtrisBoard fremtrisBoard = this.f.getBoard();
        switch (this.getGameAction(n)) {
            case 2: {
                this.f.doMove(1);
                break;
            }
            case 5: {
                this.f.doMove(3);
                break;
            }
            case 6: 
            case 8: {
                try {
                    while (fremtrisBlock.getPositionY() + fremtrisBlock.getHeight() <= fremtrisBoard.getHeight() && fremtrisBoard.canPutBlockOnBoard(fremtrisBlock)) {
                        fremtrisBlock.setPosition(fremtrisBlock.getPositionX(), fremtrisBlock.getPositionY() + 1);
                    }
                }
                catch (FremtrisGameOverException fremtrisGameOverException) {
                    this.f.gameOver();
                    return;
                }
                fremtrisBlock.setPosition(fremtrisBlock.getPositionX(), fremtrisBlock.getPositionY() - 1);
                fremtrisBoard.putBlockOnBoard(fremtrisBlock, this.f);
                this.f.nextBlock();
                break;
            }
            case 1: 
            case 9: {
                FremtrisBlock fremtrisBlock2 = fremtrisBlock.clone1();
                fremtrisBlock2.rotate();
                if (fremtrisBlock2.getPositionX() + fremtrisBlock2.getWidth() > fremtrisBoard.getWidth()) break;
                this.f.setBlock(fremtrisBlock2);
                this.paintBlockOnBoard(fremtrisBlock2, fremtrisBoard);
            }
        }
    }
}

