/*
 * Decompiled with CFR 0.152.
 */
package com.hakore.krzak.Fremtris;

import com.hakore.krzak.Fremtris.Fremtris;
import com.hakore.krzak.Fremtris.FremtrisBlock;
import com.hakore.krzak.Fremtris.FremtrisColor;
import com.hakore.krzak.Fremtris.FremtrisGameOverException;
import com.hakore.krzak.Fremtris.FremtrisTask;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FremtrisBoard {
    private int[][] board;
    private int width = 0;
    private int height = 0;
    private int block_size = 0;
    private int matrixColor = 0;
    private Image image;
    private Image background;

    FremtrisBoard(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.block_size = n3;
        this.image = Image.createImage((int)(n * n3 + 1), (int)(n2 * n3 + 1));
        this.board = this.getClearBoard();
        this.background = null;
    }

    public FremtrisBoard clone1() {
        FremtrisBoard fremtrisBoard = new FremtrisBoard(this.width, this.height, this.block_size);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                fremtrisBoard.setValueAt(i, j, this.getValueAt(i, j));
            }
        }
        fremtrisBoard.setBackgroundMatrixColor(this.matrixColor);
        return fremtrisBoard;
    }

    public void removeRowAt(int n) {
        int n2;
        int n3;
        int[][] nArray = this.getClearBoard();
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 <= this.width; ++n2) {
                nArray[n2][n3] = this.getValueAt(n2, n3);
                this.clearAt(n2, n3);
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 <= this.width; ++n2) {
                this.board[n2][n3 + 1] = nArray[n2][n3];
            }
        }
        nArray = null;
    }

    public void setValueAt(int n, int n2, int n3) {
        try {
            this.board[n][n2] = n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void clearAt(int n, int n2) {
        try {
            this.board[n][n2] = 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void clearAll() {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                this.clearAt(i, j);
            }
        }
    }

    public void fillAt(int n, int n2, int n3) {
        if (n3 == 0) {
            n3 = 1;
        }
        this.setValueAt(n, n2, n3);
    }

    public int getValueAt(int n, int n2) {
        try {
            return this.board[n][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public Image getImage() {
        return this.image;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBackgroundMatrixColor(int n) {
        this.matrixColor = n;
    }

    public Image getBackgroundImage() {
        if (this.background == null) {
            this.background = this.createBackgroundImage();
        }
        return this.background;
    }

    private Image createBackgroundImage() {
        int n;
        Image image = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics graphics = image.getGraphics();
        int n2 = image.getHeight();
        int n3 = image.getWidth();
        graphics.setColor(FremtrisColor.getColorRGB(this.matrixColor));
        for (n = 0; n <= this.width; ++n) {
            graphics.drawLine(n * this.block_size, 0, n * this.block_size, n2);
        }
        for (n = 0; n <= this.height; ++n) {
            graphics.drawLine(0, n * this.block_size, n3, n * this.block_size);
        }
        return image;
    }

    private int[][] getClearBoard() {
        return new int[this.width + 1][this.height + 1];
    }

    public boolean canPutBlockOnBoard(FremtrisBlock fremtrisBlock) throws FremtrisGameOverException {
        int n = fremtrisBlock.getWidth();
        int n2 = fremtrisBlock.getHeight();
        if (fremtrisBlock.getHeight() + fremtrisBlock.getPositionY() > this.getHeight()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.getValueAt(i + fremtrisBlock.getPositionX(), j + fremtrisBlock.getPositionY()) == 0 || fremtrisBlock.getArray()[i][j] == 0) continue;
                if (fremtrisBlock.getPositionY() <= 0) {
                    throw new FremtrisGameOverException();
                }
                return false;
            }
        }
        return true;
    }

    public void putBlockOnBoard(FremtrisBlock fremtrisBlock, Fremtris fremtris) {
        int n;
        int n2;
        boolean bl = true;
        int n3 = 0;
        int[][] nArray = fremtrisBlock.getArray();
        for (n2 = 0; n2 < fremtrisBlock.getWidth(); ++n2) {
            for (n = 0; n < fremtrisBlock.getHeight(); ++n) {
                if (nArray[n2][n] == 0) continue;
                this.setValueAt(n2 + fremtrisBlock.getPositionX(), n + fremtrisBlock.getPositionY(), fremtrisBlock.getColorCode());
            }
        }
        for (n2 = 0; n2 < this.getHeight(); ++n2) {
            for (n = 0; n < this.getWidth(); ++n) {
                if (this.getValueAt(n, n2) != 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.removeRowAt(n2);
                ++n3;
                if (++Fremtris.score > fremtris.level * 150) {
                    ++fremtris.level;
                    if (fremtris.getTimer() != null) {
                        fremtris.getTimer().cancel();
                    }
                    fremtris.setTimer(new Timer());
                    fremtris.getTask().cancel();
                    fremtris.setTask(new FremtrisTask(fremtris));
                    fremtris.delay -= fremtris.delay / (fremtris.level * 2);
                    if (fremtris.delay < 10) {
                        fremtris.delay = 1000;
                    }
                    fremtris.getTimer().schedule((TimerTask)fremtris.getTask(), fremtris.delay / 2, (long)fremtris.delay);
                }
            }
            bl = true;
        }
        if (n3 > 0) {
            Fremtris.score += n3 * fremtris.level;
        }
    }

    public void updateImage() {
        Graphics graphics = this.image.getGraphics();
        graphics.drawImage(this.getBackgroundImage(), 0, 0, 4 | 0x10);
        graphics.setClip(0, 0, this.getWidth() * this.block_size + 1, this.getHeight() * this.block_size + 1);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                if (this.getValueAt(i, j) == 0) continue;
                int n = FremtrisColor.getColorRGB(this.getValueAt(i, j));
                graphics.setColor(n);
                graphics.setColor(graphics.getGrayScale());
                graphics.drawRect(i * this.block_size, j * this.block_size, this.block_size, this.block_size);
                graphics.setColor(n);
                graphics.fillRect(i * this.block_size + 1, j * this.block_size + 1, this.block_size - 1, this.block_size - 1);
                if (Fremtris.mono) continue;
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(i * this.block_size + 1, j * this.block_size + 1, i * this.block_size + 1, j * this.block_size + 1);
            }
        }
    }
}

