/*
 * Decompiled with CFR 0.152.
 */
package com.hakore.krzak.Fremtris;

import com.hakore.krzak.Fremtris.FremtrisBlock;
import com.hakore.krzak.Fremtris.FremtrisBoard;
import com.hakore.krzak.Fremtris.FremtrisCanvas;
import com.hakore.krzak.Fremtris.FremtrisForms;
import com.hakore.krzak.Fremtris.FremtrisGameOverException;
import com.hakore.krzak.Fremtris.FremtrisNet;
import com.hakore.krzak.Fremtris.FremtrisTask;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Fremtris
extends MIDlet
implements CommandListener {
    static final byte[][] blocks = new byte[][]{{15, 0}, {7, 2}, {3, 3}, {6, 3}, {3, 6}, {7, 1}, {1, 7}};
    static final byte EMPTY = 0;
    static final byte BOARD = 1;
    static final byte BLOCK = 2;
    static final int CMD_PLAY = 0;
    static final int CMD_PAUSE = 1;
    static final int CMD_EXIT = 2;
    static final int CMD_ABOUT = 3;
    static final int CMD_LEVEL = 4;
    static final int CMD_OK = 5;
    static final int CMD_SCORES = 6;
    static final int CMD_PUBLISH = 7;
    static final int CMD_SEND = 8;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_RIGHT = 3;
    public boolean moving = false;
    private Timer timer;
    private FremtrisCanvas canvas;
    private FremtrisBoard board;
    private FremtrisBlock block;
    private TimerTask task = new FremtrisTask(this);
    private String nickName = new String("unknown");
    private TextField tf = null;
    public FremtrisBlock nextBlockInQueue = null;
    public static int score = 0;
    public int level = 1;
    public int delay = 1000;
    public static boolean mono = true;
    public static final String version = "v.0.6";
    public Command[] cmd = new Command[]{new Command("Play", 4, 1), new Command("Pause", 4, 2), new Command("Exit", 7, 1), new Command("About", 5, 1), new Command("Level", 5, 2), new Command("Done", 4, 3), new Command("High Score", 5, 3), new Command("Publish", 4, 4), new Command("Send", 4, 5)};

    public void startApp() throws MIDletStateChangeException {
        this.canvas = new FremtrisCanvas(this);
        mono = Display.getDisplay((MIDlet)this).numColors() <= 2;
        int n = this.canvas.getHeight() / 20;
        if (n < 4) {
            n = 5;
        }
        int n2 = this.canvas.getHeight() / n - 1;
        this.board = new FremtrisBoard(10, n2, n);
        this.block = new FremtrisBlock(this.board.getWidth(), this.randomBlock());
        this.canvas.addCommand(this.cmd[0]);
        this.canvas.addCommand(this.cmd[2]);
        this.canvas.addCommand(this.cmd[3]);
        this.canvas.addCommand(this.cmd[6]);
        this.canvas.setCommandListener(this);
        this.nextBlockInQueue = new FremtrisBlock(this.board.getWidth(), this.randomBlock());
        new FremtrisForms().showAbout2(Display.getDisplay((MIDlet)this), this);
    }

    public Display getgetDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void pauseApp() {
        this.task.cancel();
        this.timer.cancel();
        this.canvas.removeCommand(this.cmd[1]);
        this.canvas.addCommand(this.cmd[0]);
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd[0]) {
            this.canvas.setImage(this.board.getImage());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
            this.canvas.removeCommand(this.cmd[0]);
            this.canvas.addCommand(this.cmd[1]);
            try {
                this.task.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.task = null;
            this.task = new FremtrisTask(this);
            try {
                this.timer = new Timer();
                this.timer.schedule(this.task, this.delay / 2, (long)this.delay);
            }
            catch (IllegalStateException illegalStateException) {
                this.timer = null;
            }
        } else if (command == this.cmd[5]) {
            new FremtrisForms().showStart(Display.getDisplay((MIDlet)this), this);
        } else if (command == this.cmd[1]) {
            new FremtrisForms().showPause(Display.getDisplay((MIDlet)this), this);
            this.task.cancel();
        } else if (command == this.cmd[6]) {
            this.canvas.removeCommand(this.cmd[1]);
            this.canvas.addCommand(this.cmd[0]);
            new FremtrisForms().showHighScore(Display.getDisplay((MIDlet)this), this);
        } else if (command == this.cmd[2]) {
            this.notifyDestroyed();
        } else if (command == this.cmd[3]) {
            this.canvas.removeCommand(this.cmd[1]);
            this.canvas.addCommand(this.cmd[0]);
            new FremtrisForms().showAbout2(Display.getDisplay((MIDlet)this), this);
        } else if (command == this.cmd[7]) {
            this.tf = new FremtrisForms().askNick(Display.getDisplay((MIDlet)this), this);
        } else if (command == this.cmd[8]) {
            this.setNickName(this.tf.getString());
            new FremtrisNet().publishScore(this.getScores(false), this.getNickName());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
            this.canvas.removeCommand(this.cmd[7]);
            this.canvas.removeCommand(this.cmd[5]);
            this.canvas.removeCommand(this.cmd[1]);
            this.canvas.addCommand(this.cmd[0]);
        }
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String string) {
        this.nickName = string;
    }

    public int getDisplayHeight() {
        return this.canvas.getHeight();
    }

    public int getDisplayWidth() {
        return this.canvas.getWidth();
    }

    public FremtrisBlock getBlock() {
        return this.block;
    }

    public void setBlock(FremtrisBlock fremtrisBlock) {
        this.block = fremtrisBlock;
    }

    public void setBoard(FremtrisBoard fremtrisBoard) {
        this.board = fremtrisBoard;
    }

    public FremtrisBoard getBoard() {
        return this.board;
    }

    public FremtrisCanvas getCanvas() {
        return this.canvas;
    }

    public FremtrisTask getTask() {
        return (FremtrisTask)this.task;
    }

    public void setTask(FremtrisTask fremtrisTask) {
        this.task = fremtrisTask;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void gameOver() {
        this.getTask().cancel();
        this.getTimer().cancel();
        this.getBoard().clearAll();
        new FremtrisForms().showGameOver(Display.getDisplay((MIDlet)this), this, score);
        score = 0;
        this.level = 1;
    }

    public void nextBlock() {
        FremtrisBlock fremtrisBlock = this.nextBlockInQueue;
        try {
            if (!this.board.canPutBlockOnBoard(fremtrisBlock)) {
                return;
            }
        }
        catch (FremtrisGameOverException fremtrisGameOverException) {
            this.gameOver();
        }
        this.setBlock(fremtrisBlock);
        this.nextBlockInQueue = new FremtrisBlock(this.board.getWidth(), this.randomBlock());
    }

    public byte[] randomBlock() {
        int n = Math.abs((new Random().nextInt() & Integer.MAX_VALUE) % blocks.length);
        return blocks[n];
    }

    public void storeInScore(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"fremtrisHS", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                int n2 = Integer.parseInt(new String(recordStore.getRecord(n)));
                if (n2 < Integer.parseInt(string)) {
                    recordStore.setRecord(n, string.getBytes(), 0, string.getBytes().length);
                }
            } else {
                recordStore.addRecord(string.getBytes(), 0, string.getBytes().length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public String getScores(boolean bl) {
        try {
            String string = new String();
            RecordStore recordStore = RecordStore.openRecordStore((String)"fremtrisHS", (boolean)false);
            if (recordStore == null) {
                return null;
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                Calendar calendar = Calendar.getInstance();
                String string2 = new String(recordEnumeration.nextRecord());
                calendar.setTime(new Date(recordStore.getLastModified()));
                string = bl ? String.valueOf(string2) + " [" + calendar.get(1) + "/" + (calendar.get(2) + 1) + "/" + calendar.get(5) + "]" : String.valueOf(string2);
                string2 = null;
            }
            recordStore.closeRecordStore();
            recordStore = null;
            return string;
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
    }

    public void doMove(int n) {
        FremtrisBlock fremtrisBlock = this.getBlock();
        FremtrisBoard fremtrisBoard = this.getBoard();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.moving = true;
        FremtrisBlock fremtrisBlock2 = fremtrisBlock.clone1();
        switch (n) {
            case 1: {
                fremtrisBlock2.setPosition(fremtrisBlock2.getPositionX() - 1, fremtrisBlock2.getPositionY());
                if (fremtrisBlock2.getPositionX() < 0) break;
                bl = true;
                n2 = -1;
                break;
            }
            case 3: {
                fremtrisBlock2.setPosition(fremtrisBlock2.getPositionX() + 1, fremtrisBlock2.getPositionY());
                if (fremtrisBlock2.getPositionX() + fremtrisBlock2.getWidth() > fremtrisBoard.getWidth()) break;
                bl = true;
                n2 = 1;
            }
        }
        try {
            if (bl && fremtrisBoard.canPutBlockOnBoard(fremtrisBlock2)) {
                fremtrisBlock.setPosition(fremtrisBlock.getPositionX() + n2, fremtrisBlock.getPositionY() + n3);
                this.canvas.paintBlockOnBoard(fremtrisBlock, fremtrisBoard);
            }
        }
        catch (FremtrisGameOverException fremtrisGameOverException) {
            this.gameOver();
        }
        this.moving = false;
        fremtrisBlock2 = null;
    }
}

